model IncompressiblePipelineBase
  parameter Modelica.Fluid.Types.ModelStructure pipeModelStructure = Modelica.Fluid.Types.ModelStructure.av_vb;
  //parameter Types.ModelStructure pipeModelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b;
  replaceable package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater constrainedby Modelica.Media.Interfaces.PartialMedium;
  //replaceable package Medium =
  //    Modelica.Media.Water.StandardWaterOnePhase
  //  constrainedby Modelica.Media.Interfaces.PartialMedium;
  import Modelica.Fluid.Types.Dynamics;
  parameter Dynamics systemMassDynamics = if Medium.singleState then Dynamics.SteadyState else Dynamics.SteadyStateInitial;
  parameter Boolean filteredValveOpening = not Medium.singleState;
  inner Modelica.Fluid.System system(massDynamics = systemMassDynamics, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, use_eps_Re = true, momentumDynamics = Modelica.Fluid.Types.Dynamics.SteadyState, T_ambient = 300) annotation(Placement(visible = true, transformation(origin = {80,-80}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Fluid.Machines.PrescribedPump pump1(checkValve = true, N_nominal = 1200, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.25,0.5}, head_nominal = {100,60,0}), use_N_in = true, nParallel = 1, energyDynamics = system.energyDynamics, V(displayUnit = "l") = 0.05, massDynamics = system.massDynamics, redeclare package Medium = Medium) annotation(Placement(visible = true, transformation(origin = {-160,0}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Blocks.Sources.Ramp RPMRampPump1(height = 1000, duration = 20, offset = 1500, startTime = 50) annotation(Placement(visible = true, transformation(origin = {-180,60}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Fluid.Pipes.DynamicPipe pipeline1(use_T_start = true, length = 1000, diameter = 0.025, redeclare package Medium = Medium, modelStructure = pipeModelStructure, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, nNodes = 2, height_ab = 10) annotation(Placement(visible = true, transformation(origin = {-120,0}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Fluid.Pipes.DynamicPipe pipeline2(use_T_start = true, diameter = 0.025, redeclare package Medium = Medium, modelStructure = pipeModelStructure, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 1000, nNodes = 2, height_ab = 0) annotation(Placement(visible = true, transformation(origin = {-60,0}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Fluid.Valves.ValveIncompressible leak(redeclare package Medium = Medium, m_flow_nominal = 1, rho_nominal = 1000, CvData = Modelica.Fluid.Types.CvTypes.Av, Av = 0.025 ^ 2 / 4 * Modelica.Constants.pi, dp_nominal = 30000) annotation(Placement(visible = true, transformation(origin = {-80,-40}, extent = {{-10,10},{10,-10}}, rotation = 0)));
  Modelica.Fluid.Sources.FixedBoundary Atmosphere(nPorts = 1, redeclare package Medium = Medium, p = system.p_ambient, T = system.T_ambient) annotation(Placement(visible = true, transformation(origin = {-20,-40}, extent = {{12.5,-12.5},{-12.5,12.5}}, rotation = 0)));
  Modelica.Blocks.Sources.Ramp RPMRampPump2(height = -500, duration = 20, offset = 1500, startTime = 70) annotation(Placement(visible = true, transformation(origin = {-40,60}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Fluid.Pipes.DynamicPipe pipeline3(use_T_start = true, diameter = 0.025, redeclare package Medium = Medium, modelStructure = pipeModelStructure, length = 2000, nNodes = 2) annotation(Placement(visible = true, transformation(origin = {60,0}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Fluid.Machines.PrescribedPump pump2(checkValve = true, N_nominal = 1200, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.25,0.5}, head_nominal = {100,60,0}), use_N_in = true, nParallel = 1, energyDynamics = system.energyDynamics, V(displayUnit = "l") = 0.05, massDynamics = system.massDynamics, redeclare package Medium = Medium) annotation(Placement(visible = true, transformation(origin = {20,0}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Blocks.Sources.Ramp LeakOpening(height = 0.1, duration = 10, offset = 0, startTime = 100) annotation(Placement(visible = true, transformation(origin = {-100,-80}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Medium, p = system.p_ambient, T = system.T_ambient, use_X_in = false) annotation(Placement(visible = true, transformation(origin = {-200,0}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Medium, p = system.p_ambient, T = system.T_ambient) annotation(Placement(visible = true, transformation(origin = {200,0}, extent = {{10,-10},{-10,10}}, rotation = 0)));
equation
  connect(Sink.ports[1],pipeline3.port_b) annotation(Line(points = {{190,0},{69.8241,0},{69.8241,0},{69.8241,0}}));
  connect(Source.ports[1],pump1.port_a) annotation(Line(points = {{-190,0},{-169.689,0},{-169.689,0.270636},{-169.689,0.270636}}));
  connect(pipeline1.port_b,leak.port_a) annotation(Line(points = {{-110,0},{-99.32340000000001,0},{-99.32340000000001,-40.5954},{-89.85120000000001,-40.5954},{-89.85120000000001,-40.5954}}));
  connect(pipeline1.port_b,pipeline2.port_a) annotation(Line(points = {{-110,0},{-69.5535,0},{-69.5535,0.270636},{-69.5535,0.270636}}));
  connect(LeakOpening.y,leak.opening) annotation(Line(points = {{-89,-80},{-80.1083,-80},{-80.1083,-48.7145},{-80.1083,-48.7145}}));
  connect(pump2.port_b,pipeline3.port_a) annotation(Line(points = {{30,0},{50.0677,0},{50.0677,0},{50.0677,0}}));
  connect(pipeline2.port_b,pump2.port_a) annotation(Line(points = {{-50,0},{9.20162,0},{9.20162,0.270636},{9.20162,0.270636}}));
  connect(RPMRampPump2.y,pump2.N_in) annotation(Line(points = {{-29,60},{20.2977,60},{20.2977,11.3667},{20.2977,11.3667}}));
  connect(pump1.port_b,pipeline1.port_a) annotation(Line(points = {{-150,0},{-130.176,0},{-130.176,0},{-130.176,0}}));
  connect(leak.port_b,Atmosphere.ports[1]) annotation(Line(points = {{-70,-40},{-33.0176,-40},{-33.0176,-39.5129},{-33.0176,-39.5129}}));
  connect(RPMRampPump1.y,pump1.N_in) annotation(Line(points = {{-169,60},{-159.675,60},{-159.675,11.0961},{-159.675,11.0961}}));
  annotation(Icon(coordinateSystem(extent = {{-100,-100},{100,100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2,2})), Diagram(coordinateSystem(extent = {{-100,-100},{100,100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2,2})));
end IncompressiblePipelineBase;